'use strict';

describe('services/sessionService.js', function () {

  var $session, $cookies = null;

  beforeEach(module('genisis'));

  beforeEach(function () {
    inject(function (session, _$cookies_) {
      $session = session;
      $cookies = _$cookies_;

      //make sure we clear out the cookies each time
      $cookies.remove('genisis');
    });
  });

  it('service exists', function () {
    expect($session).not.toBeNull();
  });

  describe('$session.set() function', function () {
    it('exists', function () {
      expect($session.set).toBeDefined();
    });

    it('sets a key value pair on a genisis cookie', function () {
      expect($session.set('key', 'value')).toEqual(true);
      expect($cookies.get('genisis')).toEqual('{"key":"value"}');
    });

    it('overwrites the value in the key if it already exists', function () {
      expect($session.set('key', 'value')).toEqual(true);
      expect($cookies.get('genisis')).toEqual('{"key":"value"}');
      expect($session.set('key', 'test')).toEqual(true);
      expect($cookies.get('genisis')).toEqual('{"key":"test"}');
    });

    it('stores values for multiple keys', function () {
      expect($session.set('key', 'value')).toEqual(true);
      expect($cookies.get('genisis')).toEqual('{"key":"value"}');
      expect($session.set('key2', '123')).toEqual(true);
      expect($cookies.get('genisis')).toEqual(
        '{"key":"value","key2":"123"}');
    });
  });

  describe('$session.remove() function', function () {
    it('exists', function () {
      expect($session.remove).toBeDefined();
    });

    it('returns false if the key does not exist in the session',
      function () {
        expect($session.remove('test')).toEqual(false);

        $session.set('test', 'value');

        expect($session.remove('value')).toEqual(false);
        expect($session.remove('testing')).toEqual(false);
      });

    it('returns true and removes the value if in the session', function () {

      $session.set('test', 'value');
      $session.set('testing', '123');
      $session.set('value', 'is the key');

      expect($cookies.get('genisis')).toEqual(
        '{"test":"value","testing":"123","value":"is the key"}'
      );

      expect($session.remove('test')).toEqual(true);
      expect($cookies.get('genisis')).toEqual(
        '{"testing":"123","value":"is the key"}'
      );

      expect($session.remove('value')).toEqual(true);
      expect($cookies.get('genisis')).toEqual('{"testing":"123"}');

      expect($session.remove('testing')).toEqual(true);
      expect($cookies.get('genisis')).toEqual('{}');
    });
  });

  describe('$session.delete() function', function () {
    it('exists', function () {
      expect($session.delete).toBeDefined();
    });

    it('removes the cookie for genisis', function () {
      $session.set('key', 'value');
      expect($session.delete()).toEqual(true);
    });

    it('returns false if there is no cookie yet', function () {
      expect($session.delete()).toEqual(false);
    });
  });

  describe('$session.get() function', function () {
    it('exists', function () {
      expect($session.get).toBeDefined();
    });

    it('returns a value if it exists in the session', function () {
      $session.set('key', 'value');
      expect($session.get('key')).toEqual('value');
    });

    it('returns an empty object if the value does not exist', function () {
      expect($session.get('nonexistant')).toEqual({});
    });

    it('returns the session if no key is given', function () {
      $session.set('test', 'testing');
      expect($session.get()).toEqual({
        test: 'testing'
      });
    });
  });
});